/*
 * WIrelessNetwork
 * an object that will represent a wireless network in the system
 *
 */

function WirelessNetwork(macAddress){
	// the mac address of the base station is used as a unique identifier
	// it is used in comparison in methods like equals()
	this.macAddress = macAddress;
	// the vendor of the network
	this.vendor = "";
	// the name of the network (SSID)
	this.name = "";
	// the signal strength of the network
	this.signal = 0;
	// the speed of the network
	this.speed = 0;
	// the channel of the network - 1 to 11 in North America - 1 to 13 other places.
	this.channel = 0;
	// WEP || WPA || none == ""
	this.encryption = "";
	// determines if the nework makes the list.
	this.inertia = 0;
	
	this.visible = false;
	this.connected = false;
}


// Required for JavaScript version 1.1 to fucntion properly
new WirelessNetwork(0);

// sort by channel || signal || name
WirelessNetwork.prototype.sortBy = "channel";

// 
WirelessNetwork.prototype.displayEncrypted = true;

// 
WirelessNetwork.prototype.baseInertia = 15;

// WIrelessNework Update
function WirelessNetwork_Update(name, signal, speed, channel, encryption, vendor){
	this.name = name;
	this.signal = signal;
	this.speed = speed;
	this.channel = channel;
	this.vendor = vendor;
	
	this.visible = true;
	
	switch(encryption){
		case 0:
			this.encryption = "";
			break;
		case 1:
			this.encryption = "WEP";
			break;
		case 2:
			this.encryption = "WPA";
			break;
		default:
			this.encryption = "";

	}
	
	this.connected = false;
	
	this.inertia = this.signal + this.baseInertia;
}

WirelessNetwork.prototype.Update = WirelessNetwork_Update;


// WIrelessNework Update
function WirelessNetwork_UpdateVendor(vendor){
	this.vendor = vendor;
}

WirelessNetwork.prototype.UpdateVendor = WirelessNetwork_UpdateVendor;

// WIrelessNework Update
function WirelessNetwork_Vendor(){
	return this.macAddress.substr(0,2) + this.macAddress.substr(3,2) + this.macAddress.substr(6,2) ;
}

WirelessNetwork.prototype.Vendor = WirelessNetwork_Vendor;


// WIrelessNework UpdateFromArray - update the Network based on the values stored in an array
function WirelessNetwork_UpdateFromArray(array){
	
	if(array.length >= 8){
		this.name = array[0];
		this.signal = array[5];
		this.speed = array[3];
		this.channel = array[6];
		this.vendor = array[4];
		
		this.encryption = array[1].substr(0,3);
		
		if(this.encryption == "non")
			this.encryption = "";
		
		this.visible = true;
		this.inertia = this.signal + this.baseInertia;
		
		//alert("FULL"+array);
	}
	// the data does not include speed info - we are not connected to it.
	else if(array.length >= 6){
		this.name = array[0];
		this.channel = array[3];
		this.vendor = array[2];
		this.signal = array[4];
		this.speed = 0;
		
		switch(array[5]){
			case 0:
				this.encryption = "";
				break;
			case 1:
				this.encryption = "WEP";
				break;
			case 2:
				this.encryption = "WPA";
				break;
			default:
				this.encryption = "";
	
		}
		
		this.visible = true;
		this.inertia = this.signal + this.baseInertia;
		
		//alert("NOSPEED"+array);
	}
}

WirelessNetwork.prototype.UpdateFromArray = WirelessNetwork_UpdateFromArray;


// WirelessNetwork Refresh - returns true if network is still active - false if network is dead.
function WirelessNetwork_Refresh(){
	this.inertia -= 10;
	
	if(this.inertia < 0){
		this.inertia = 0;
		return false;	
	}
	else
		return true;
}

WirelessNetwork.prototype.Refresh = WirelessNetwork_Refresh;

// WirelessNetwork
function WirelessNetwork_toString(){
	return this.name + " - " + this.macAddress + "\n" +
		"channel: " + this.channel + " speed: " + this.speed +
		"\nsignal: " + this.signal + " connected: " + this.connected +
		"\nvendor: " + this.vendor + " encryption: " + this.encryption;

}

WirelessNetwork.prototype.toString = WirelessNetwork_toString;


// WirelessNetwork 
function WirelessNetwork_toHTMLString(isAirPortExtreme){
	var status;
	
	if(this.connected){
		if(this.signal >= 60)
			status = "connected_blue";
		else if(this.signal >= 40)
			status = "connected_green";
		else if(this.signal >= 30)
			status = "connected_yellow";
		else if(this.signal >= 20)
			status = "connected_orange";
		else if(this.signal >= 0)
			status = "connected_red";
	}
	else if(this.visible){
		if(this.signal >= 60)
			status = "active_blue";
		else if(this.signal >= 40)
			status = "active_green";
		else if(this.signal >= 30)
			status = "active_yellow";
		else if(this.signal >= 20)
			status = "active_orange";
		else if(this.signal >= 0)
			status = "active_red";
	}
	else if(this.inertia > 0)
		status = "inactive";
	else
		status = "hidden";
		
	var descriptionString = this.name+" ["+this.vendor+"]";
	
	if(descriptionString.length >= 24){
		descriptionString = descriptionString.substr(0,20) + "...";
	}
	
	// Error with AirPort Acces is resolved so this code is no longer needed.
	/*
	if(isAirPortExtreme){
	
		return "<ul class=\""+status+"\" onClick=\"connectToNetwork('"+this.name+"','"+this.encryption+"', false)\">\n"
			+"<li class=\"list_channel\">"+this.channel+"</li>"
			+"<li class=\"list_signal\">"+this.signal+"</li>"
			+"<li class=\"list_encryption\">"+this.encryption+"</li>"
			+"<li class=\"list_details_noencrypt\">"+descriptionString+"</li>"
			+"</ul>";
	}
	else if(this.encryption == "WEP" || this.encryption == ""){
	
		return "<ul class=\""+status+"\" onClick=\"connectToNetwork('"+this.name+"','"+this.encryption+"', false)\">\n"
			+"<li class=\"list_channel\">"+this.channel+"</li>"
			+"<li class=\"list_signal\">"+this.signal+"</li>"
			+"<li class=\"list_encryption\">"+this.encryption+"</li>"
			+"<li class=\"list_details_noencrypt\">"+descriptionString+"</li>"
			+"</ul>";		
	}
	else if(this.encryption == "WPA" || this.encryption == "WPA2"){
	
		return "<ul class=\""+status+"\">\n"
			+"<li class=\"list_channel\">"+this.channel+"</li>"
			+"<li class=\"list_signal\">"+this.signal+"</li>"
			+"<li class=\"list_encryption\">"+this.encryption+"</li>"
			+"<li class=\"list_details\">"+descriptionString+"</li>"
			+"</ul>";
		
	}
	else{
	*/
	
		return "<ul class=\""+status+"\" onClick=\"connectToNetwork('"+this.name+"','"+this.encryption+"', false)\">\n"
			+"<li class=\"list_channel\">"+this.channel+"</li>"
			+"<li class=\"list_signal\">"+this.signal+"</li>"
			+"<li class=\"list_encryption\">"+this.encryption+"</li>"
			+"<li class=\"list_details_noencrypt\">"+descriptionString+"</li>"
			+"</ul>";
	//}
		
	
}

WirelessNetwork.prototype.toHTMLString = WirelessNetwork_toHTMLString;


